#include <bits/stdc++.h>
using namespace std;

using ll = long long;
const ll INF = (ll)4e18;

struct Mast {
    ll x, h;
    int id;
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<Mast> a(n);
    for (int i = 0; i < n; i++) cin >> a[i].x;
    for (int i = 0; i < n; i++) {
        cin >> a[i].h;
        a[i].id = i;
    }

    sort(a.begin(), a.end(), [](auto &A, auto &B) {
        return A.x < B.x;
    });

    vector<ll> ans(n, INF);

    /* ---------- LEFT TO RIGHT ---------- */
    stack<int> st;
    for (int i = 0; i < n; i++) {
        while (!st.empty() && a[st.top()].h < a[i].h) {
            int j = st.top(); st.pop();
            ll dx = abs(a[i].x - a[j].x);
            ll dy = abs(a[i].h - a[j].h);
            ans[a[j].id] = min(ans[a[j].id], dx + dy);
        }
        st.push(i);
    }
    while (!st.empty()) st.pop();

    /* ---------- RIGHT TO LEFT ---------- */
    for (int i = n - 1; i >= 0; i--) {
        while (!st.empty() && a[st.top()].h < a[i].h) {
            int j = st.top(); st.pop();
            ll dx = abs(a[i].x - a[j].x);
            ll dy = abs(a[i].h - a[j].h);
            ans[a[j].id] = min(ans[a[j].id], dx + dy);
        }
        st.push(i);
    }

    /* ---------- OUTPUT ---------- */
    for (int i = 0; i < n; i++) {
        if (ans[i] == INF) cout << -1 << '\n';
        else cout << ans[i] << '\n';
    }

    return 0;
}